"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alwaysPresentCertificateWarnText = exports.allowClientCertificatesNeededForSSLCertificateErrorText = void 0;
exports.checkCookieConfig = checkCookieConfig;
exports.checkDoNotFailOnForbidden = checkDoNotFailOnForbidden;
exports.checkTLSConfig = checkTLSConfig;
exports.xPackSecurityErrorText = exports.failedCheckDoNotFailOnForbiddenText = exports.doNotFailOnForbiddenText = exports.defaultCookiePasswordWarnText = exports.cookieSecureFalseWarnText = void 0;
var _default_config = require("../../default_config");
/* eslint-disable @kbn/eslint/require-license-header */

const xPackSecurityErrorText = 'X-Pack Security needs to be disabled for Search Guard to work properly. Please set "xpack.security.enabled" to false in your kibana.yml';
exports.xPackSecurityErrorText = xPackSecurityErrorText;
const doNotFailOnForbiddenText = '"Do not fail on forbidden" is not enabled. Please refer to the documentation: https://docs.search-guard.com/latest/kibana-plugin-installation#configuring-elasticsearch-enable-do-not-fail-on-forbidden';
exports.doNotFailOnForbiddenText = doNotFailOnForbiddenText;
const failedCheckDoNotFailOnForbiddenText = 'Failed to verify the "not_fail_on_forbidden_enabled" option.';
exports.failedCheckDoNotFailOnForbiddenText = failedCheckDoNotFailOnForbiddenText;
const allowClientCertificatesNeededForSSLCertificateErrorText = '"elasticsearch.ssl.certificate" can not be used without setting "searchguard.allow_client_certificates" to "true" in kibana.yml. Please refer to the documentation for more information about the implications of doing so: https://docs.search-guard.com/latest/kibana-plugin-installation#client-certificates-elasticsearchsslcertificate';
exports.allowClientCertificatesNeededForSSLCertificateErrorText = allowClientCertificatesNeededForSSLCertificateErrorText;
const alwaysPresentCertificateWarnText = "'elasticsearch.ssl.alwaysPresentCertificate' may lead to requests being executed as the user attached to the certificate configured in 'elasticsearch.ssl.certificate'.";
exports.alwaysPresentCertificateWarnText = alwaysPresentCertificateWarnText;
const defaultCookiePasswordWarnText = "Default cookie password detected, please set a password in kibana.yml by setting 'searchguard.cookie.password' (min. 32 characters).";
exports.defaultCookiePasswordWarnText = defaultCookiePasswordWarnText;
const cookieSecureFalseWarnText = "'searchguard.cookie.secure' is set to false, cookies are transmitted over unsecure HTTP connection. Consider using HTTPS and set this key to 'true'";
exports.cookieSecureFalseWarnText = cookieSecureFalseWarnText;
async function checkDoNotFailOnForbidden({
  searchGuardBackend,
  logger
}) {
  try {
    const response = await searchGuardBackend.getKibanaInfoWithInternalUser();
    if (response && response.not_fail_on_forbidden_enabled !== true) {
      logger.warn(doNotFailOnForbiddenText);
    }
  } catch (error) {
    logger.error(`${failedCheckDoNotFailOnForbiddenText} ${error.toString()}`);
  }
}
function checkTLSConfig({
  configService,
  logger
}) {
  const sslConfig = configService.get('elasticsearch.ssl', {});
  if (typeof sslConfig.certificate !== 'undefined' && sslConfig.certificate !== false) {
    if (configService.get('searchguard.allow_client_certificates') !== true) {
      logger.error(allowClientCertificatesNeededForSSLCertificateErrorText);
      throw new Error(allowClientCertificatesNeededForSSLCertificateErrorText);
    }
    if (sslConfig.alwaysPresentCertificate === true) {
      // Client certificates allowed, but we still want to warn if alwaysPresentCertificate is true.
      logger.warn(alwaysPresentCertificateWarnText);
    }
  }
}
function checkCookieConfig({
  configService,
  logger
}) {
  if (configService.get('searchguard.cookie.password') === _default_config.DEFAULT_CONFIG.searchguard.cookie.password) {
    logger.warn(defaultCookiePasswordWarnText);
  }
  if (configService.get('searchguard.cookie.secure') !== true) {
    logger.warn(cookieSecureFalseWarnText);
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfZGVmYXVsdF9jb25maWciLCJyZXF1aXJlIiwieFBhY2tTZWN1cml0eUVycm9yVGV4dCIsImV4cG9ydHMiLCJkb05vdEZhaWxPbkZvcmJpZGRlblRleHQiLCJmYWlsZWRDaGVja0RvTm90RmFpbE9uRm9yYmlkZGVuVGV4dCIsImFsbG93Q2xpZW50Q2VydGlmaWNhdGVzTmVlZGVkRm9yU1NMQ2VydGlmaWNhdGVFcnJvclRleHQiLCJhbHdheXNQcmVzZW50Q2VydGlmaWNhdGVXYXJuVGV4dCIsImRlZmF1bHRDb29raWVQYXNzd29yZFdhcm5UZXh0IiwiY29va2llU2VjdXJlRmFsc2VXYXJuVGV4dCIsImNoZWNrRG9Ob3RGYWlsT25Gb3JiaWRkZW4iLCJzZWFyY2hHdWFyZEJhY2tlbmQiLCJsb2dnZXIiLCJyZXNwb25zZSIsImdldEtpYmFuYUluZm9XaXRoSW50ZXJuYWxVc2VyIiwibm90X2ZhaWxfb25fZm9yYmlkZGVuX2VuYWJsZWQiLCJ3YXJuIiwiZXJyb3IiLCJ0b1N0cmluZyIsImNoZWNrVExTQ29uZmlnIiwiY29uZmlnU2VydmljZSIsInNzbENvbmZpZyIsImdldCIsImNlcnRpZmljYXRlIiwiRXJyb3IiLCJhbHdheXNQcmVzZW50Q2VydGlmaWNhdGUiLCJjaGVja0Nvb2tpZUNvbmZpZyIsIkRFRkFVTFRfQ09ORklHIiwic2VhcmNoZ3VhcmQiLCJjb29raWUiLCJwYXNzd29yZCJdLCJzb3VyY2VzIjpbInNhbml0eV9jaGVja3MuanMiXSwic291cmNlc0NvbnRlbnQiOlsiLyogZXNsaW50LWRpc2FibGUgQGtibi9lc2xpbnQvcmVxdWlyZS1saWNlbnNlLWhlYWRlciAqL1xuaW1wb3J0IHsgREVGQVVMVF9DT05GSUcgfSBmcm9tICcuLi8uLi9kZWZhdWx0X2NvbmZpZyc7XG5cbmV4cG9ydCBjb25zdCB4UGFja1NlY3VyaXR5RXJyb3JUZXh0ID1cbiAgJ1gtUGFjayBTZWN1cml0eSBuZWVkcyB0byBiZSBkaXNhYmxlZCBmb3IgU2VhcmNoIEd1YXJkIHRvIHdvcmsgcHJvcGVybHkuIFBsZWFzZSBzZXQgXCJ4cGFjay5zZWN1cml0eS5lbmFibGVkXCIgdG8gZmFsc2UgaW4geW91ciBraWJhbmEueW1sJztcblxuZXhwb3J0IGNvbnN0IGRvTm90RmFpbE9uRm9yYmlkZGVuVGV4dCA9XG4gICdcIkRvIG5vdCBmYWlsIG9uIGZvcmJpZGRlblwiIGlzIG5vdCBlbmFibGVkLiBQbGVhc2UgcmVmZXIgdG8gdGhlIGRvY3VtZW50YXRpb246IGh0dHBzOi8vZG9jcy5zZWFyY2gtZ3VhcmQuY29tL2xhdGVzdC9raWJhbmEtcGx1Z2luLWluc3RhbGxhdGlvbiNjb25maWd1cmluZy1lbGFzdGljc2VhcmNoLWVuYWJsZS1kby1ub3QtZmFpbC1vbi1mb3JiaWRkZW4nO1xuXG5leHBvcnQgY29uc3QgZmFpbGVkQ2hlY2tEb05vdEZhaWxPbkZvcmJpZGRlblRleHQgPVxuICAnRmFpbGVkIHRvIHZlcmlmeSB0aGUgXCJub3RfZmFpbF9vbl9mb3JiaWRkZW5fZW5hYmxlZFwiIG9wdGlvbi4nO1xuXG5leHBvcnQgY29uc3QgYWxsb3dDbGllbnRDZXJ0aWZpY2F0ZXNOZWVkZWRGb3JTU0xDZXJ0aWZpY2F0ZUVycm9yVGV4dCA9XG4gICdcImVsYXN0aWNzZWFyY2guc3NsLmNlcnRpZmljYXRlXCIgY2FuIG5vdCBiZSB1c2VkIHdpdGhvdXQgc2V0dGluZyBcInNlYXJjaGd1YXJkLmFsbG93X2NsaWVudF9jZXJ0aWZpY2F0ZXNcIiB0byBcInRydWVcIiBpbiBraWJhbmEueW1sLiBQbGVhc2UgcmVmZXIgdG8gdGhlIGRvY3VtZW50YXRpb24gZm9yIG1vcmUgaW5mb3JtYXRpb24gYWJvdXQgdGhlIGltcGxpY2F0aW9ucyBvZiBkb2luZyBzbzogaHR0cHM6Ly9kb2NzLnNlYXJjaC1ndWFyZC5jb20vbGF0ZXN0L2tpYmFuYS1wbHVnaW4taW5zdGFsbGF0aW9uI2NsaWVudC1jZXJ0aWZpY2F0ZXMtZWxhc3RpY3NlYXJjaHNzbGNlcnRpZmljYXRlJztcblxuZXhwb3J0IGNvbnN0IGFsd2F5c1ByZXNlbnRDZXJ0aWZpY2F0ZVdhcm5UZXh0ID1cbiAgXCInZWxhc3RpY3NlYXJjaC5zc2wuYWx3YXlzUHJlc2VudENlcnRpZmljYXRlJyBtYXkgbGVhZCB0byByZXF1ZXN0cyBiZWluZyBleGVjdXRlZCBhcyB0aGUgdXNlciBhdHRhY2hlZCB0byB0aGUgY2VydGlmaWNhdGUgY29uZmlndXJlZCBpbiAnZWxhc3RpY3NlYXJjaC5zc2wuY2VydGlmaWNhdGUnLlwiO1xuXG5leHBvcnQgY29uc3QgZGVmYXVsdENvb2tpZVBhc3N3b3JkV2FyblRleHQgPVxuICBcIkRlZmF1bHQgY29va2llIHBhc3N3b3JkIGRldGVjdGVkLCBwbGVhc2Ugc2V0IGEgcGFzc3dvcmQgaW4ga2liYW5hLnltbCBieSBzZXR0aW5nICdzZWFyY2hndWFyZC5jb29raWUucGFzc3dvcmQnIChtaW4uIDMyIGNoYXJhY3RlcnMpLlwiO1xuXG5leHBvcnQgY29uc3QgY29va2llU2VjdXJlRmFsc2VXYXJuVGV4dCA9XG4gIFwiJ3NlYXJjaGd1YXJkLmNvb2tpZS5zZWN1cmUnIGlzIHNldCB0byBmYWxzZSwgY29va2llcyBhcmUgdHJhbnNtaXR0ZWQgb3ZlciB1bnNlY3VyZSBIVFRQIGNvbm5lY3Rpb24uIENvbnNpZGVyIHVzaW5nIEhUVFBTIGFuZCBzZXQgdGhpcyBrZXkgdG8gJ3RydWUnXCI7XG5cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBjaGVja0RvTm90RmFpbE9uRm9yYmlkZGVuKHsgc2VhcmNoR3VhcmRCYWNrZW5kLCBsb2dnZXIgfSkge1xuICB0cnkge1xuICAgIGNvbnN0IHJlc3BvbnNlID0gYXdhaXQgc2VhcmNoR3VhcmRCYWNrZW5kLmdldEtpYmFuYUluZm9XaXRoSW50ZXJuYWxVc2VyKCk7XG4gICAgaWYgKHJlc3BvbnNlICYmIHJlc3BvbnNlLm5vdF9mYWlsX29uX2ZvcmJpZGRlbl9lbmFibGVkICE9PSB0cnVlKSB7XG4gICAgICBsb2dnZXIud2Fybihkb05vdEZhaWxPbkZvcmJpZGRlblRleHQpO1xuICAgIH1cbiAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICBsb2dnZXIuZXJyb3IoYCR7ZmFpbGVkQ2hlY2tEb05vdEZhaWxPbkZvcmJpZGRlblRleHR9ICR7ZXJyb3IudG9TdHJpbmcoKX1gKTtcbiAgfVxufVxuXG5leHBvcnQgZnVuY3Rpb24gY2hlY2tUTFNDb25maWcoeyBjb25maWdTZXJ2aWNlLCBsb2dnZXIgfSkge1xuICBjb25zdCBzc2xDb25maWcgPSBjb25maWdTZXJ2aWNlLmdldCgnZWxhc3RpY3NlYXJjaC5zc2wnLCB7fSk7XG5cbiAgaWYgKHR5cGVvZiBzc2xDb25maWcuY2VydGlmaWNhdGUgIT09ICd1bmRlZmluZWQnICYmIHNzbENvbmZpZy5jZXJ0aWZpY2F0ZSAhPT0gZmFsc2UpIHtcbiAgICBpZiAoY29uZmlnU2VydmljZS5nZXQoJ3NlYXJjaGd1YXJkLmFsbG93X2NsaWVudF9jZXJ0aWZpY2F0ZXMnKSAhPT0gdHJ1ZSkge1xuICAgICAgbG9nZ2VyLmVycm9yKGFsbG93Q2xpZW50Q2VydGlmaWNhdGVzTmVlZGVkRm9yU1NMQ2VydGlmaWNhdGVFcnJvclRleHQpO1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGFsbG93Q2xpZW50Q2VydGlmaWNhdGVzTmVlZGVkRm9yU1NMQ2VydGlmaWNhdGVFcnJvclRleHQpO1xuICAgIH1cblxuICAgIGlmIChzc2xDb25maWcuYWx3YXlzUHJlc2VudENlcnRpZmljYXRlID09PSB0cnVlKSB7XG4gICAgICAvLyBDbGllbnQgY2VydGlmaWNhdGVzIGFsbG93ZWQsIGJ1dCB3ZSBzdGlsbCB3YW50IHRvIHdhcm4gaWYgYWx3YXlzUHJlc2VudENlcnRpZmljYXRlIGlzIHRydWUuXG4gICAgICBsb2dnZXIud2FybihhbHdheXNQcmVzZW50Q2VydGlmaWNhdGVXYXJuVGV4dCk7XG4gICAgfVxuICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBjaGVja0Nvb2tpZUNvbmZpZyh7IGNvbmZpZ1NlcnZpY2UsIGxvZ2dlciB9KSB7XG4gIGlmIChcbiAgICBjb25maWdTZXJ2aWNlLmdldCgnc2VhcmNoZ3VhcmQuY29va2llLnBhc3N3b3JkJykgPT09IERFRkFVTFRfQ09ORklHLnNlYXJjaGd1YXJkLmNvb2tpZS5wYXNzd29yZFxuICApIHtcbiAgICBsb2dnZXIud2FybihkZWZhdWx0Q29va2llUGFzc3dvcmRXYXJuVGV4dCk7XG4gIH1cblxuICBpZiAoY29uZmlnU2VydmljZS5nZXQoJ3NlYXJjaGd1YXJkLmNvb2tpZS5zZWN1cmUnKSAhPT0gdHJ1ZSkge1xuICAgIGxvZ2dlci53YXJuKGNvb2tpZVNlY3VyZUZhbHNlV2FyblRleHQpO1xuICB9XG59XG4iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7QUFDQSxJQUFBQSxlQUFBLEdBQUFDLE9BQUE7QUFEQTs7QUFHTyxNQUFNQyxzQkFBc0IsR0FDakMseUlBQXlJO0FBQUNDLE9BQUEsQ0FBQUQsc0JBQUEsR0FBQUEsc0JBQUE7QUFFckksTUFBTUUsd0JBQXdCLEdBQ25DLHlNQUF5TTtBQUFDRCxPQUFBLENBQUFDLHdCQUFBLEdBQUFBLHdCQUFBO0FBRXJNLE1BQU1DLG1DQUFtQyxHQUM5Qyw4REFBOEQ7QUFBQ0YsT0FBQSxDQUFBRSxtQ0FBQSxHQUFBQSxtQ0FBQTtBQUUxRCxNQUFNQyx1REFBdUQsR0FDbEUsNlVBQTZVO0FBQUNILE9BQUEsQ0FBQUcsdURBQUEsR0FBQUEsdURBQUE7QUFFelUsTUFBTUMsZ0NBQWdDLEdBQzNDLHlLQUF5SztBQUFDSixPQUFBLENBQUFJLGdDQUFBLEdBQUFBLGdDQUFBO0FBRXJLLE1BQU1DLDZCQUE2QixHQUN4QyxzSUFBc0k7QUFBQ0wsT0FBQSxDQUFBSyw2QkFBQSxHQUFBQSw2QkFBQTtBQUVsSSxNQUFNQyx5QkFBeUIsR0FDcEMscUpBQXFKO0FBQUNOLE9BQUEsQ0FBQU0seUJBQUEsR0FBQUEseUJBQUE7QUFFakosZUFBZUMseUJBQXlCQSxDQUFDO0VBQUVDLGtCQUFrQjtFQUFFQztBQUFPLENBQUMsRUFBRTtFQUM5RSxJQUFJO0lBQ0YsTUFBTUMsUUFBUSxHQUFHLE1BQU1GLGtCQUFrQixDQUFDRyw2QkFBNkIsRUFBRTtJQUN6RSxJQUFJRCxRQUFRLElBQUlBLFFBQVEsQ0FBQ0UsNkJBQTZCLEtBQUssSUFBSSxFQUFFO01BQy9ESCxNQUFNLENBQUNJLElBQUksQ0FBQ1osd0JBQXdCLENBQUM7SUFDdkM7RUFDRixDQUFDLENBQUMsT0FBT2EsS0FBSyxFQUFFO0lBQ2RMLE1BQU0sQ0FBQ0ssS0FBSyxDQUFFLEdBQUVaLG1DQUFvQyxJQUFHWSxLQUFLLENBQUNDLFFBQVEsRUFBRyxFQUFDLENBQUM7RUFDNUU7QUFDRjtBQUVPLFNBQVNDLGNBQWNBLENBQUM7RUFBRUMsYUFBYTtFQUFFUjtBQUFPLENBQUMsRUFBRTtFQUN4RCxNQUFNUyxTQUFTLEdBQUdELGFBQWEsQ0FBQ0UsR0FBRyxDQUFDLG1CQUFtQixFQUFFLENBQUMsQ0FBQyxDQUFDO0VBRTVELElBQUksT0FBT0QsU0FBUyxDQUFDRSxXQUFXLEtBQUssV0FBVyxJQUFJRixTQUFTLENBQUNFLFdBQVcsS0FBSyxLQUFLLEVBQUU7SUFDbkYsSUFBSUgsYUFBYSxDQUFDRSxHQUFHLENBQUMsdUNBQXVDLENBQUMsS0FBSyxJQUFJLEVBQUU7TUFDdkVWLE1BQU0sQ0FBQ0ssS0FBSyxDQUFDWCx1REFBdUQsQ0FBQztNQUNyRSxNQUFNLElBQUlrQixLQUFLLENBQUNsQix1REFBdUQsQ0FBQztJQUMxRTtJQUVBLElBQUllLFNBQVMsQ0FBQ0ksd0JBQXdCLEtBQUssSUFBSSxFQUFFO01BQy9DO01BQ0FiLE1BQU0sQ0FBQ0ksSUFBSSxDQUFDVCxnQ0FBZ0MsQ0FBQztJQUMvQztFQUNGO0FBQ0Y7QUFFTyxTQUFTbUIsaUJBQWlCQSxDQUFDO0VBQUVOLGFBQWE7RUFBRVI7QUFBTyxDQUFDLEVBQUU7RUFDM0QsSUFDRVEsYUFBYSxDQUFDRSxHQUFHLENBQUMsNkJBQTZCLENBQUMsS0FBS0ssOEJBQWMsQ0FBQ0MsV0FBVyxDQUFDQyxNQUFNLENBQUNDLFFBQVEsRUFDL0Y7SUFDQWxCLE1BQU0sQ0FBQ0ksSUFBSSxDQUFDUiw2QkFBNkIsQ0FBQztFQUM1QztFQUVBLElBQUlZLGFBQWEsQ0FBQ0UsR0FBRyxDQUFDLDJCQUEyQixDQUFDLEtBQUssSUFBSSxFQUFFO0lBQzNEVixNQUFNLENBQUNJLElBQUksQ0FBQ1AseUJBQXlCLENBQUM7RUFDeEM7QUFDRiJ9